<?php
function generatePortalsJSON($db) {

    $res = $db->select("dns", "*");

    $portals = [];
    $i = 0;

    foreach ($res as $row) {
        $portals[] = [
            "id" => $i,
            "name" => $row['title'],
            "url" => $row['url'],
            "epg_url" => ""
        ];
        $i++;
    }

    $jsonData = json_encode(
        ["portals" => $portals],
        JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES
    );

    $file = __DIR__ . "/../api/portals.json";
    file_put_contents($file, $jsonData);
}
